'use strict';

/* --------------------------------------------------------------
	geschaeftskundenversand-form.js 2016-08-22
	Gambio GmbH
	http://www.gambio.de
	Copyright (c) 2016 Gambio GmbH
	Released under the GNU General Public License (Version 2)
	[http://www.gnu.org/licenses/gpl-2.0.html]
	--------------------------------------------------------------
*/

$(function () {
    $('#toggle-extd-view').on('click', function (e) {
        e.preventDefault();
        $('.extd-view').toggle();
    });
    $('.extd-view').hide();

    $('select#gkv_product_index').on('change', function (e) {
        var $option = $('option:selected', this),
            product = $option.data('dhl_product'),
            isExport = $option.data('dhl_targetarea') !== 'domestic';

        $('input, select', 'div.dhl_service').attr('disabled', 'disabled');
        $('input[type="checkbox"]', 'div.dhl_service').closest('span.single-checkbox').addClass('disabled');
        $('input, select', 'div.dhl_service.' + product).removeAttr('disabled');
        $('input[type="checkbox"]', 'div.dhl_service.' + product).closest('span.single-checkbox').removeClass('disabled');
        $('div.exportdoc').toggle(isExport);
    });
    $('select#gkv_product_index').change();

    $('select.country').on('change', function (e) {
        var shipper_country = $('select.shipper_country').val(),
            receiver_country = $('select.receiver_country:visible').val(),
            isExport = shipper_country !== receiver_country;
        if (shipper_country !== undefined && receiver_country !== undefined) {
            if (isExport === true) {
                // alert('to export ' + shipper_country + ' ' + receiver_country);
                $('select#gkv_product_index').val($('select#gkv_product_index option').not('option[data-dhl_targetarea="domestic"]').first().val());
                $('select#gkv_product_index').trigger('change');
                $('div.exportdoc').show();
            } else {
                // alert('to domestic ' + shipper_country + ' ' + receiver_country);
                $('select#gkv_product_index').val($('select#gkv_product_index option[data-dhl_targetarea="domestic"]').first().val());
                $('select#gkv_product_index').trigger('change');
                $('div.exportdoc').hide();
            }
        }
    });

    $('select#receiver_type').on('change', function (e) {
        var $option = $('option:selected', this),
            receiver_type = $option.attr('value');
        $('div.receiver_data').each(function () {
            $(this).toggle($(this).hasClass('receiver_' + receiver_type));
        });
        $('select.country').first().trigger('change');
    });
    $('select#receiver_type').trigger('change');

    $('button#customize_shipper').on('click', function (e) {
        e.preventDefault();
        $('div.customize-shipper-button').remove();
        $('div.customize-shipper').css('display', 'inline-block');
    });

    $('button#customize_returnreceiver').on('click', function (e) {
        e.preventDefault();
        $('div.customize-returnreceiver-button').remove();
        $('div.customize-returnreceiver').css('display', 'inline-block');
    });

    $('input[name="identcheck"]').on('change', function (e) {
        $('.dhl_service_identcheck').toggle($(this).get(0).checked);
    });
    $('input[name="identcheck"]').trigger('change');

    /*
    $('select[name="exportdoc/exporttype"]').on('change', function(e) {
        const exportActivated = $(this).val() !== 'NONE';
        $('div.exportdoc').not($(this).closest('div.exportdoc')).toggle(exportActivated);
    });
    $('select[name="exportdoc/exporttype"]').trigger('change');
    */

    $('button#add_export_position').on('click', function (e) {
        e.preventDefault();
        var $newrow = $('table.exportpositions tr.template_row').clone(true);
        $newrow.removeClass('template_row');
        $('table.exportpositions tbody').append($newrow);
    });

    $('button.remove_row').on('click', function (e) {
        e.preventDefault();
        $(this).closest('tr').remove();
    });

    $('button#cod_helper').on('click', function (e) {
        e.preventDefault();
        var cod_amount = $(this).data('cod_amount');
        $('input[name="cashondelivery"]').val(cod_amount);
    });
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImdlc2NoYWVmdHNrdW5kZW52ZXJzYW5kLWZvcm0uanMiXSwibmFtZXMiOlsiJCIsIm9uIiwiZSIsInByZXZlbnREZWZhdWx0IiwidG9nZ2xlIiwiaGlkZSIsIiRvcHRpb24iLCJwcm9kdWN0IiwiZGF0YSIsImlzRXhwb3J0IiwiYXR0ciIsImNsb3Nlc3QiLCJhZGRDbGFzcyIsInJlbW92ZUF0dHIiLCJyZW1vdmVDbGFzcyIsImNoYW5nZSIsInNoaXBwZXJfY291bnRyeSIsInZhbCIsInJlY2VpdmVyX2NvdW50cnkiLCJ1bmRlZmluZWQiLCJub3QiLCJmaXJzdCIsInRyaWdnZXIiLCJzaG93IiwicmVjZWl2ZXJfdHlwZSIsImVhY2giLCJoYXNDbGFzcyIsInJlbW92ZSIsImNzcyIsImdldCIsImNoZWNrZWQiLCIkbmV3cm93IiwiY2xvbmUiLCJhcHBlbmQiLCJjb2RfYW1vdW50Il0sIm1hcHBpbmdzIjoiOztBQUFBOzs7Ozs7Ozs7O0FBVUFBLEVBQUUsWUFBWTtBQUNWQSxNQUFFLG1CQUFGLEVBQXVCQyxFQUF2QixDQUEwQixPQUExQixFQUFtQyxVQUFVQyxDQUFWLEVBQWE7QUFDNUNBLFVBQUVDLGNBQUY7QUFDQUgsVUFBRSxZQUFGLEVBQWdCSSxNQUFoQjtBQUNILEtBSEQ7QUFJQUosTUFBRSxZQUFGLEVBQWdCSyxJQUFoQjs7QUFFQUwsTUFBRSwwQkFBRixFQUE4QkMsRUFBOUIsQ0FBaUMsUUFBakMsRUFBMkMsVUFBVUMsQ0FBVixFQUFhO0FBQ3BELFlBQU1JLFVBQVVOLEVBQUUsaUJBQUYsRUFBcUIsSUFBckIsQ0FBaEI7QUFBQSxZQUNJTyxVQUFVRCxRQUFRRSxJQUFSLENBQWEsYUFBYixDQURkO0FBQUEsWUFFSUMsV0FBV0gsUUFBUUUsSUFBUixDQUFhLGdCQUFiLE1BQW1DLFVBRmxEOztBQUlBUixVQUFFLGVBQUYsRUFBbUIsaUJBQW5CLEVBQXNDVSxJQUF0QyxDQUEyQyxVQUEzQyxFQUF1RCxVQUF2RDtBQUNBVixVQUFFLHdCQUFGLEVBQTRCLGlCQUE1QixFQUErQ1csT0FBL0MsQ0FBdUQsc0JBQXZELEVBQStFQyxRQUEvRSxDQUF3RixVQUF4RjtBQUNBWixVQUFFLGVBQUYsRUFBbUIscUJBQXFCTyxPQUF4QyxFQUFpRE0sVUFBakQsQ0FBNEQsVUFBNUQ7QUFDQWIsVUFBRSx3QkFBRixFQUE0QixxQkFBcUJPLE9BQWpELEVBQTBESSxPQUExRCxDQUFrRSxzQkFBbEUsRUFBMEZHLFdBQTFGLENBQXNHLFVBQXRHO0FBQ0FkLFVBQUUsZUFBRixFQUFtQkksTUFBbkIsQ0FBMEJLLFFBQTFCO0FBQ0gsS0FWRDtBQVdBVCxNQUFFLDBCQUFGLEVBQThCZSxNQUE5Qjs7QUFFQWYsTUFBRSxnQkFBRixFQUFvQkMsRUFBcEIsQ0FBdUIsUUFBdkIsRUFBaUMsVUFBVUMsQ0FBVixFQUFhO0FBQzFDLFlBQU1jLGtCQUFrQmhCLEVBQUUsd0JBQUYsRUFBNEJpQixHQUE1QixFQUF4QjtBQUFBLFlBQ0lDLG1CQUFtQmxCLEVBQUUsaUNBQUYsRUFBcUNpQixHQUFyQyxFQUR2QjtBQUFBLFlBRUlSLFdBQVdPLG9CQUFvQkUsZ0JBRm5DO0FBR0EsWUFBSUYsb0JBQW9CRyxTQUFwQixJQUFpQ0QscUJBQXFCQyxTQUExRCxFQUFxRTtBQUNqRSxnQkFBSVYsYUFBYSxJQUFqQixFQUF1QjtBQUNuQjtBQUNBVCxrQkFBRSwwQkFBRixFQUE4QmlCLEdBQTlCLENBQWtDakIsRUFBRSxpQ0FBRixFQUFxQ29CLEdBQXJDLENBQXlDLHdDQUF6QyxFQUFtRkMsS0FBbkYsR0FBMkZKLEdBQTNGLEVBQWxDO0FBQ0FqQixrQkFBRSwwQkFBRixFQUE4QnNCLE9BQTlCLENBQXNDLFFBQXRDO0FBQ0F0QixrQkFBRSxlQUFGLEVBQW1CdUIsSUFBbkI7QUFDSCxhQUxELE1BS087QUFDSDtBQUNBdkIsa0JBQUUsMEJBQUYsRUFBOEJpQixHQUE5QixDQUFrQ2pCLEVBQUUsaUVBQUYsRUFBcUVxQixLQUFyRSxHQUE2RUosR0FBN0UsRUFBbEM7QUFDQWpCLGtCQUFFLDBCQUFGLEVBQThCc0IsT0FBOUIsQ0FBc0MsUUFBdEM7QUFDQXRCLGtCQUFFLGVBQUYsRUFBbUJLLElBQW5CO0FBQ0g7QUFDSjtBQUNKLEtBakJEOztBQW1CQUwsTUFBRSxzQkFBRixFQUEwQkMsRUFBMUIsQ0FBNkIsUUFBN0IsRUFBdUMsVUFBVUMsQ0FBVixFQUFhO0FBQ2hELFlBQU1JLFVBQVVOLEVBQUUsaUJBQUYsRUFBcUIsSUFBckIsQ0FBaEI7QUFBQSxZQUNJd0IsZ0JBQWdCbEIsUUFBUUksSUFBUixDQUFhLE9BQWIsQ0FEcEI7QUFFQVYsVUFBRSxtQkFBRixFQUF1QnlCLElBQXZCLENBQTRCLFlBQVk7QUFDcEN6QixjQUFFLElBQUYsRUFBUUksTUFBUixDQUFlSixFQUFFLElBQUYsRUFBUTBCLFFBQVIsQ0FBaUIsY0FBY0YsYUFBL0IsQ0FBZjtBQUNILFNBRkQ7QUFHQXhCLFVBQUUsZ0JBQUYsRUFBb0JxQixLQUFwQixHQUE0QkMsT0FBNUIsQ0FBb0MsUUFBcEM7QUFDSCxLQVBEO0FBUUF0QixNQUFFLHNCQUFGLEVBQTBCc0IsT0FBMUIsQ0FBa0MsUUFBbEM7O0FBRUF0QixNQUFFLDBCQUFGLEVBQThCQyxFQUE5QixDQUFpQyxPQUFqQyxFQUEwQyxVQUFVQyxDQUFWLEVBQWE7QUFDbkRBLFVBQUVDLGNBQUY7QUFDQUgsVUFBRSw4QkFBRixFQUFrQzJCLE1BQWxDO0FBQ0EzQixVQUFFLHVCQUFGLEVBQTJCNEIsR0FBM0IsQ0FBK0IsU0FBL0IsRUFBMEMsY0FBMUM7QUFDSCxLQUpEOztBQU1BNUIsTUFBRSxpQ0FBRixFQUFxQ0MsRUFBckMsQ0FBd0MsT0FBeEMsRUFBaUQsVUFBVUMsQ0FBVixFQUFhO0FBQzFEQSxVQUFFQyxjQUFGO0FBQ0FILFVBQUUscUNBQUYsRUFBeUMyQixNQUF6QztBQUNBM0IsVUFBRSw4QkFBRixFQUFrQzRCLEdBQWxDLENBQXNDLFNBQXRDLEVBQWlELGNBQWpEO0FBQ0gsS0FKRDs7QUFNQTVCLE1BQUUsMEJBQUYsRUFBOEJDLEVBQTlCLENBQWlDLFFBQWpDLEVBQTJDLFVBQVVDLENBQVYsRUFBYTtBQUNwREYsVUFBRSx5QkFBRixFQUE2QkksTUFBN0IsQ0FBb0NKLEVBQUUsSUFBRixFQUFRNkIsR0FBUixDQUFZLENBQVosRUFBZUMsT0FBbkQ7QUFDSCxLQUZEO0FBR0E5QixNQUFFLDBCQUFGLEVBQThCc0IsT0FBOUIsQ0FBc0MsUUFBdEM7O0FBRUE7Ozs7Ozs7O0FBUUF0QixNQUFFLDRCQUFGLEVBQWdDQyxFQUFoQyxDQUFtQyxPQUFuQyxFQUE0QyxVQUFVQyxDQUFWLEVBQWE7QUFDckRBLFVBQUVDLGNBQUY7QUFDQSxZQUFJNEIsVUFBVS9CLEVBQUUsdUNBQUYsRUFBMkNnQyxLQUEzQyxDQUFpRCxJQUFqRCxDQUFkO0FBQ0FELGdCQUFRakIsV0FBUixDQUFvQixjQUFwQjtBQUNBZCxVQUFFLDZCQUFGLEVBQWlDaUMsTUFBakMsQ0FBd0NGLE9BQXhDO0FBQ0gsS0FMRDs7QUFPQS9CLE1BQUUsbUJBQUYsRUFBdUJDLEVBQXZCLENBQTBCLE9BQTFCLEVBQW1DLFVBQVVDLENBQVYsRUFBYTtBQUM1Q0EsVUFBRUMsY0FBRjtBQUNBSCxVQUFFLElBQUYsRUFBUVcsT0FBUixDQUFnQixJQUFoQixFQUFzQmdCLE1BQXRCO0FBQ0gsS0FIRDs7QUFLQTNCLE1BQUUsbUJBQUYsRUFBdUJDLEVBQXZCLENBQTBCLE9BQTFCLEVBQW1DLFVBQVVDLENBQVYsRUFBYTtBQUM1Q0EsVUFBRUMsY0FBRjtBQUNBLFlBQUkrQixhQUFhbEMsRUFBRSxJQUFGLEVBQVFRLElBQVIsQ0FBYSxZQUFiLENBQWpCO0FBQ0FSLFVBQUUsOEJBQUYsRUFBa0NpQixHQUFsQyxDQUFzQ2lCLFVBQXRDO0FBQ0gsS0FKRDtBQU1ILENBNUZEIiwiZmlsZSI6Imdlc2NoYWVmdHNrdW5kZW52ZXJzYW5kLWZvcm0uanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiAtLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLVxuXHRnZXNjaGFlZnRza3VuZGVudmVyc2FuZC1mb3JtLmpzIDIwMTYtMDgtMjJcblx0R2FtYmlvIEdtYkhcblx0aHR0cDovL3d3dy5nYW1iaW8uZGVcblx0Q29weXJpZ2h0IChjKSAyMDE2IEdhbWJpbyBHbWJIXG5cdFJlbGVhc2VkIHVuZGVyIHRoZSBHTlUgR2VuZXJhbCBQdWJsaWMgTGljZW5zZSAoVmVyc2lvbiAyKVxuXHRbaHR0cDovL3d3dy5nbnUub3JnL2xpY2Vuc2VzL2dwbC0yLjAuaHRtbF1cblx0LS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS1cbiovXG5cbiQoZnVuY3Rpb24gKCkge1xuICAgICQoJyN0b2dnbGUtZXh0ZC12aWV3Jykub24oJ2NsaWNrJywgZnVuY3Rpb24gKGUpIHtcbiAgICAgICAgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICAkKCcuZXh0ZC12aWV3JykudG9nZ2xlKCk7XG4gICAgfSk7XG4gICAgJCgnLmV4dGQtdmlldycpLmhpZGUoKTtcblxuICAgICQoJ3NlbGVjdCNna3ZfcHJvZHVjdF9pbmRleCcpLm9uKCdjaGFuZ2UnLCBmdW5jdGlvbiAoZSkge1xuICAgICAgICBjb25zdCAkb3B0aW9uID0gJCgnb3B0aW9uOnNlbGVjdGVkJywgdGhpcyksXG4gICAgICAgICAgICBwcm9kdWN0ID0gJG9wdGlvbi5kYXRhKCdkaGxfcHJvZHVjdCcpLFxuICAgICAgICAgICAgaXNFeHBvcnQgPSAkb3B0aW9uLmRhdGEoJ2RobF90YXJnZXRhcmVhJykgIT09ICdkb21lc3RpYyc7XG5cbiAgICAgICAgJCgnaW5wdXQsIHNlbGVjdCcsICdkaXYuZGhsX3NlcnZpY2UnKS5hdHRyKCdkaXNhYmxlZCcsICdkaXNhYmxlZCcpO1xuICAgICAgICAkKCdpbnB1dFt0eXBlPVwiY2hlY2tib3hcIl0nLCAnZGl2LmRobF9zZXJ2aWNlJykuY2xvc2VzdCgnc3Bhbi5zaW5nbGUtY2hlY2tib3gnKS5hZGRDbGFzcygnZGlzYWJsZWQnKTtcbiAgICAgICAgJCgnaW5wdXQsIHNlbGVjdCcsICdkaXYuZGhsX3NlcnZpY2UuJyArIHByb2R1Y3QpLnJlbW92ZUF0dHIoJ2Rpc2FibGVkJyk7XG4gICAgICAgICQoJ2lucHV0W3R5cGU9XCJjaGVja2JveFwiXScsICdkaXYuZGhsX3NlcnZpY2UuJyArIHByb2R1Y3QpLmNsb3Nlc3QoJ3NwYW4uc2luZ2xlLWNoZWNrYm94JykucmVtb3ZlQ2xhc3MoJ2Rpc2FibGVkJyk7XG4gICAgICAgICQoJ2Rpdi5leHBvcnRkb2MnKS50b2dnbGUoaXNFeHBvcnQpO1xuICAgIH0pO1xuICAgICQoJ3NlbGVjdCNna3ZfcHJvZHVjdF9pbmRleCcpLmNoYW5nZSgpO1xuXG4gICAgJCgnc2VsZWN0LmNvdW50cnknKS5vbignY2hhbmdlJywgZnVuY3Rpb24gKGUpIHtcbiAgICAgICAgY29uc3Qgc2hpcHBlcl9jb3VudHJ5ID0gJCgnc2VsZWN0LnNoaXBwZXJfY291bnRyeScpLnZhbCgpLFxuICAgICAgICAgICAgcmVjZWl2ZXJfY291bnRyeSA9ICQoJ3NlbGVjdC5yZWNlaXZlcl9jb3VudHJ5OnZpc2libGUnKS52YWwoKSxcbiAgICAgICAgICAgIGlzRXhwb3J0ID0gc2hpcHBlcl9jb3VudHJ5ICE9PSByZWNlaXZlcl9jb3VudHJ5O1xuICAgICAgICBpZiAoc2hpcHBlcl9jb3VudHJ5ICE9PSB1bmRlZmluZWQgJiYgcmVjZWl2ZXJfY291bnRyeSAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICAgICAgICBpZiAoaXNFeHBvcnQgPT09IHRydWUpIHtcbiAgICAgICAgICAgICAgICAvLyBhbGVydCgndG8gZXhwb3J0ICcgKyBzaGlwcGVyX2NvdW50cnkgKyAnICcgKyByZWNlaXZlcl9jb3VudHJ5KTtcbiAgICAgICAgICAgICAgICAkKCdzZWxlY3QjZ2t2X3Byb2R1Y3RfaW5kZXgnKS52YWwoJCgnc2VsZWN0I2drdl9wcm9kdWN0X2luZGV4IG9wdGlvbicpLm5vdCgnb3B0aW9uW2RhdGEtZGhsX3RhcmdldGFyZWE9XCJkb21lc3RpY1wiXScpLmZpcnN0KCkudmFsKCkpO1xuICAgICAgICAgICAgICAgICQoJ3NlbGVjdCNna3ZfcHJvZHVjdF9pbmRleCcpLnRyaWdnZXIoJ2NoYW5nZScpO1xuICAgICAgICAgICAgICAgICQoJ2Rpdi5leHBvcnRkb2MnKS5zaG93KCk7XG4gICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgIC8vIGFsZXJ0KCd0byBkb21lc3RpYyAnICsgc2hpcHBlcl9jb3VudHJ5ICsgJyAnICsgcmVjZWl2ZXJfY291bnRyeSk7XG4gICAgICAgICAgICAgICAgJCgnc2VsZWN0I2drdl9wcm9kdWN0X2luZGV4JykudmFsKCQoJ3NlbGVjdCNna3ZfcHJvZHVjdF9pbmRleCBvcHRpb25bZGF0YS1kaGxfdGFyZ2V0YXJlYT1cImRvbWVzdGljXCJdJykuZmlyc3QoKS52YWwoKSk7XG4gICAgICAgICAgICAgICAgJCgnc2VsZWN0I2drdl9wcm9kdWN0X2luZGV4JykudHJpZ2dlcignY2hhbmdlJyk7XG4gICAgICAgICAgICAgICAgJCgnZGl2LmV4cG9ydGRvYycpLmhpZGUoKTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH0pO1xuXG4gICAgJCgnc2VsZWN0I3JlY2VpdmVyX3R5cGUnKS5vbignY2hhbmdlJywgZnVuY3Rpb24gKGUpIHtcbiAgICAgICAgY29uc3QgJG9wdGlvbiA9ICQoJ29wdGlvbjpzZWxlY3RlZCcsIHRoaXMpLFxuICAgICAgICAgICAgcmVjZWl2ZXJfdHlwZSA9ICRvcHRpb24uYXR0cigndmFsdWUnKTtcbiAgICAgICAgJCgnZGl2LnJlY2VpdmVyX2RhdGEnKS5lYWNoKGZ1bmN0aW9uICgpIHtcbiAgICAgICAgICAgICQodGhpcykudG9nZ2xlKCQodGhpcykuaGFzQ2xhc3MoJ3JlY2VpdmVyXycgKyByZWNlaXZlcl90eXBlKSk7XG4gICAgICAgIH0pO1xuICAgICAgICAkKCdzZWxlY3QuY291bnRyeScpLmZpcnN0KCkudHJpZ2dlcignY2hhbmdlJyk7XG4gICAgfSk7XG4gICAgJCgnc2VsZWN0I3JlY2VpdmVyX3R5cGUnKS50cmlnZ2VyKCdjaGFuZ2UnKTtcblxuICAgICQoJ2J1dHRvbiNjdXN0b21pemVfc2hpcHBlcicpLm9uKCdjbGljaycsIGZ1bmN0aW9uIChlKSB7XG4gICAgICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICAgICAgJCgnZGl2LmN1c3RvbWl6ZS1zaGlwcGVyLWJ1dHRvbicpLnJlbW92ZSgpO1xuICAgICAgICAkKCdkaXYuY3VzdG9taXplLXNoaXBwZXInKS5jc3MoJ2Rpc3BsYXknLCAnaW5saW5lLWJsb2NrJyk7XG4gICAgfSk7XG5cbiAgICAkKCdidXR0b24jY3VzdG9taXplX3JldHVybnJlY2VpdmVyJykub24oJ2NsaWNrJywgZnVuY3Rpb24gKGUpIHtcbiAgICAgICAgZS5wcmV2ZW50RGVmYXVsdCgpO1xuICAgICAgICAkKCdkaXYuY3VzdG9taXplLXJldHVybnJlY2VpdmVyLWJ1dHRvbicpLnJlbW92ZSgpO1xuICAgICAgICAkKCdkaXYuY3VzdG9taXplLXJldHVybnJlY2VpdmVyJykuY3NzKCdkaXNwbGF5JywgJ2lubGluZS1ibG9jaycpO1xuICAgIH0pO1xuXG4gICAgJCgnaW5wdXRbbmFtZT1cImlkZW50Y2hlY2tcIl0nKS5vbignY2hhbmdlJywgZnVuY3Rpb24gKGUpIHtcbiAgICAgICAgJCgnLmRobF9zZXJ2aWNlX2lkZW50Y2hlY2snKS50b2dnbGUoJCh0aGlzKS5nZXQoMCkuY2hlY2tlZCk7XG4gICAgfSk7XG4gICAgJCgnaW5wdXRbbmFtZT1cImlkZW50Y2hlY2tcIl0nKS50cmlnZ2VyKCdjaGFuZ2UnKTtcblxuICAgIC8qXG4gICAgJCgnc2VsZWN0W25hbWU9XCJleHBvcnRkb2MvZXhwb3J0dHlwZVwiXScpLm9uKCdjaGFuZ2UnLCBmdW5jdGlvbihlKSB7XG4gICAgICAgIGNvbnN0IGV4cG9ydEFjdGl2YXRlZCA9ICQodGhpcykudmFsKCkgIT09ICdOT05FJztcbiAgICAgICAgJCgnZGl2LmV4cG9ydGRvYycpLm5vdCgkKHRoaXMpLmNsb3Nlc3QoJ2Rpdi5leHBvcnRkb2MnKSkudG9nZ2xlKGV4cG9ydEFjdGl2YXRlZCk7XG4gICAgfSk7XG4gICAgJCgnc2VsZWN0W25hbWU9XCJleHBvcnRkb2MvZXhwb3J0dHlwZVwiXScpLnRyaWdnZXIoJ2NoYW5nZScpO1xuICAgICovXG5cbiAgICAkKCdidXR0b24jYWRkX2V4cG9ydF9wb3NpdGlvbicpLm9uKCdjbGljaycsIGZ1bmN0aW9uIChlKSB7XG4gICAgICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICAgICAgbGV0ICRuZXdyb3cgPSAkKCd0YWJsZS5leHBvcnRwb3NpdGlvbnMgdHIudGVtcGxhdGVfcm93JykuY2xvbmUodHJ1ZSk7XG4gICAgICAgICRuZXdyb3cucmVtb3ZlQ2xhc3MoJ3RlbXBsYXRlX3JvdycpO1xuICAgICAgICAkKCd0YWJsZS5leHBvcnRwb3NpdGlvbnMgdGJvZHknKS5hcHBlbmQoJG5ld3Jvdyk7XG4gICAgfSk7XG5cbiAgICAkKCdidXR0b24ucmVtb3ZlX3JvdycpLm9uKCdjbGljaycsIGZ1bmN0aW9uIChlKSB7XG4gICAgICAgIGUucHJldmVudERlZmF1bHQoKTtcbiAgICAgICAgJCh0aGlzKS5jbG9zZXN0KCd0cicpLnJlbW92ZSgpO1xuICAgIH0pO1xuXG4gICAgJCgnYnV0dG9uI2NvZF9oZWxwZXInKS5vbignY2xpY2snLCBmdW5jdGlvbiAoZSkge1xuICAgICAgICBlLnByZXZlbnREZWZhdWx0KCk7XG4gICAgICAgIGxldCBjb2RfYW1vdW50ID0gJCh0aGlzKS5kYXRhKCdjb2RfYW1vdW50Jyk7XG4gICAgICAgICQoJ2lucHV0W25hbWU9XCJjYXNob25kZWxpdmVyeVwiXScpLnZhbChjb2RfYW1vdW50KTtcbiAgICB9KVxuXG59KTtcbiJdfQ==
